package mcfall.raytracer.tests;

import mcfall.math.ColumnVector;
import mcfall.math.RowVector;

public class Point extends TestCase {

	mcfall.math.Point origin;
	mcfall.math.Point negativeOne2D;
	mcfall.math.Point positiveOne2D;
	mcfall.math.Point negativeOne3D;
	mcfall.math.Point positiveOne3D;
	
	
	protected void setUp() throws Exception {
		origin = new mcfall.math.Point (0, 0, 0);
		negativeOne2D = new mcfall.math.Point (-1, -1);
		negativeOne3D = new mcfall.math.Point (-1, -1, -1);
		positiveOne2D = new mcfall.math.Point (1, 1);
		positiveOne3D = new mcfall.math.Point (1, 1, 1);
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/*
	 * Test method for 'mcfall.raytracer.Point.distance(Point)'
	 */
	public void testDistance() {
		assertAlmostEquals (Math.sqrt(2.0), origin.distance(positiveOne2D));
		assertAlmostEquals (Math.sqrt(2.0), origin.distance(negativeOne2D));
		assertAlmostEquals (Math.sqrt(3.0), origin.distance(positiveOne3D));
		assertAlmostEquals (Math.sqrt(3.0), origin.distance(negativeOne3D));
		assertAlmostEquals (Math.sqrt(12.0), negativeOne3D.distance(positiveOne3D));
		mcfall.math.Point other = new mcfall.math.Point (1, 2, 3);
		assertAlmostEquals (Math.sqrt(14.0), other.distance(origin));
	}

	/*
	 * Test method for 'mcfall.raytracer.Point.moveBy(Vector)'
	 */
	public void testMoveByVector() {
		origin.set(0, 0, 0);
		//  First test moving by a 2-D column vector
		ColumnVector columnVector = new ColumnVector (2);
		columnVector.setValueAt(1, 1.0);
		columnVector.setValueAt(2, 2.0);
		origin.moveBy(columnVector);
		assertEquals (1.0, origin.getX());
		assertEquals (2.0, origin.getY());
		assertEquals (0.0, origin.getZ());
		
		//  And a 3-D column vector
		origin.set(0.0, 0.0, 0.0);
		columnVector = new ColumnVector (3);
		columnVector.setValueAt(1, 1.0);
		columnVector.setValueAt(2, 2.0);
		columnVector.setValueAt(3, 3.0);
		origin.moveBy(columnVector);
		assertEquals(1.0, origin.getX());
		assertEquals(2.0, origin.getY());
		assertEquals(3.0, origin.getZ());
		
		//  Now try moving by a 2-D row vector
		origin.set(0.0, 0.0, 0.0);
		RowVector rowVector = new RowVector (2);
		rowVector.setValueAt(1, 1.0);
		rowVector.setValueAt(2, 2.0);
		origin.moveBy (rowVector);
		assertEquals (1.0, origin.getX());
		assertEquals (2.0, origin.getY());
		assertEquals (0.0, origin.getZ());
		
		//  And a 3-D row vector
		origin.set(0.0, 0.0, 0.0);		
		rowVector = new RowVector (3);
		rowVector.setValueAt(1, 1.0);
		rowVector.setValueAt(2, 2.0);
		rowVector.setValueAt(3, 3.0);
		origin.moveBy(rowVector);
		assertEquals (1.0, origin.getX());
		assertEquals (2.0, origin.getY());
		assertEquals (3.0, origin.getZ());
		
	}

	public void testGetX () {
		assertEquals (1.0, positiveOne3D.getX());
	}
	
	public void testGetY () {
		assertEquals (1.0, positiveOne3D.getY());
	}
	
	public void testGetZ () {
		assertEquals (1.0, positiveOne3D.getZ());
	}
	
	public void testSetX () {
		origin.setX (5.0);
		assertEquals (5.0, origin.getX());
	}
	
	public void testSetY () {
		origin.setY (5.0);
		assertEquals (5.0, origin.getY());
	}
	
	public void testSetZ () {
		origin.setZ (5.0);
		assertEquals (5.0, origin.getZ());
	}
	
	/*
	 * Test method for 'mcfall.raytracer.Point.moveBy(Vector, double)'
	 */
	/*
	public void testMoveByVectorDouble() {
		//  Just do 3D row and column vectors here, because I'm lazy
		ColumnVector columnVector = new ColumnVector (3);
		columnVector.setValueAt(1, 2);
		columnVector.setValueAt(2, 1);
		columnVector.setValueAt(3, 1);
		
		double magnitude = columnVector.length();
		origin.moveBy(columnVector, 0.5);
		assertAlmostEquals(1.0, origin.getX());
		assertAlmostEquals(0.5, origin.getY());
		assertAlmostEquals(0.5, origin.getZ());
		
	}
	*/
}
